class X2Ability_BioticGuardianSet extends X2Ability config(GameData_SoldierSkills);

var config int WarpShot_Cooldown;

var config int WarpShot_Rupture;

var config int WarpShot_Damage;

var config int WarpShot_Ammo;

var config float ReactiveBarrier_Dmg_Adjust;

var config int BIOTIC_DEFENCE; 

var config int BarrierPoints;

var config int RegenPoints;

var config int SafeguardPoints;

var config int TeleportCooldown;

var config int Teleport_Range;

var config int FIELD_RADIUS;

var config int FIELD_PSIMULTI;

var config int FIELD_MINRADIUS;

var config int FIELD_MAXRADIUS;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;

	Templates.AddItem(WarpShot()); //guaranteed +3/+5/+7 rupture shot that does low damage


	Templates.AddItem(BioticTraversal()); //jump up to rooftops, +10 defence

	Templates.AddItem(ReactiveBarrier()); //all damage taken is reduced to 75%


	Templates.AddItem(BioticTeleport()); //can teleport up to 8 tiles away without triggering overwatch

	Templates.AddItem(Safeguard()); // 10 shield points that can regenerate, replaces Biotic Barrier
	Templates.AddItem(SafeguardRegen()); //to account for new limit

	Templates.AddItem(RuptureField()); //targets within 6 tiles at the start of this unit's turn will suffer +6/+8/+10 rupture

	Templates.AddItem(BioticWind()); //sustain but biotic also gains 10 shield points
	Templates.AddItem(BioticWindTriggered());


	Templates.AddItem(BioticStrength()); //bonus damage based off psi strength
	Templates.AddItem(BioticBarrier()); //6 shield points that can regenerate
	Templates.AddItem(BioticRegen());
	Templates.AddItem(BioticRebuild());	

	return Templates;
}


static function X2AbilityTemplate BioticStrength()
{
	local X2AbilityTemplate						Template;
	local X2AbilityTargetStyle                  TargetStyle;
	local X2AbilityTrigger						Trigger;
	local X2Effect_BioticStrength                 PaddingEffect;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticStrength');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_mind_plus";

	Template.AbilityToHitCalc = default.DeadEye;

	TargetStyle = new class'X2AbilityTarget_Self';
	Template.AbilityTargetStyle = TargetStyle;

	Trigger = new class'X2AbilityTrigger_UnitPostBeginPlay';
	Template.AbilityTriggers.AddItem(Trigger);

	PaddingEffect = new class'X2Effect_BioticStrength';
	PaddingEffect.BuildPersistentEffect(1, true, false);
	PaddingEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyHelpText(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(PaddingEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!


	return Template;
}


static function X2AbilityTemplate RuptureField()
{
 
 	local X2AbilityTemplate                 Template;
	local X2AbilityTrigger_EventListener    Trigger;
 // 	local X2Condition_UnitValue				ShooterCondition;	 //here
//	local X2Condition_UnitEffects			ShooterEffects;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect, BonusDamageEffect;
	local X2AbilityMultiTarget_Radius_RMPsi RadiusMultiTarget;
	local X2Condition_UnitProperty          HealTargetCondition;
	local X2Condition_UnitProperty						SourceNotConcealedCondition;
	local X2Condition_AbilityProperty   DevastateCondition;
	local X2Condition_AbilityProperty   ExplodingCondition;
	local X2Effect_Persistent               DisorientedEffect;
	local X2Effect_Persistent           PersistentEffect;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_RuptureField');

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Offensive;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_blossom";
	Template.AbilitySourceName = 'eAbilitySource_Psionic';

	Trigger = new class'X2AbilityTrigger_EventListener';
	Trigger.ListenerData.Deferral = ELD_OnStateSubmitted;
	Trigger.ListenerData.EventID = 'PlayerTurnEnded'; //fires at the start of turns
	Trigger.ListenerData.Filter = eFilter_Player;
 	Trigger.ListenerData.EventFn = class'XComGameState_Ability'.static.AbilityTriggerEventListener_Self;
	Template.AbilityTriggers.AddItem(Trigger);


	RadiusMultiTarget = new class'X2AbilityMultiTarget_Radius_RMPsi';
	RadiusMultiTarget.fTargetRadius = default.FIELD_RADIUS;
	RadiusMultiTarget.bIgnoreBlockingCover = true;
	RadiusMultiTarget.bAllowDeadMultiTargetUnits = false;
	RadiusMultiTarget.PsiMulti = default.FIELD_PSIMULTI;
	RadiusMultiTarget.MinRadius = default.FIELD_MINRADIUS;
	RadiusMultiTarget.MaxRadius = default.FIELD_MAXRADIUS;
	Template.AbilityMultiTargetStyle = RadiusMultiTarget;

	X2AbilityMultiTarget_Radius(Template.AbilityMultiTargetStyle).AddAbilityBonusRadius('RM_ExplodingBiotics', class'RM_Helpers'.default.RadiiBonus);

	//Don't trigger when the source is concealed
	SourceNotConcealedCondition = new class'X2Condition_UnitProperty';
	SourceNotConcealedCondition.ExcludeConcealed = true;
	Template.AbilityShooterConditions.AddItem(SourceNotConcealedCondition);
	
	WeaponDamageEffect = class'X2Ability_GrenadierAbilitySet'.static.ShredderDamageEffect();
	WeaponDamageEffect.bIgnoreBaseDamage = true;
	WeaponDamageEffect.DamageTag = 'RuptureField';
	Template.AddMultiTargetEffect(WeaponDamageEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddMultiTargetEffect(BonusDamageEffect);

	//  This is a dummy effect so that an icon shows up in the UI.
	PersistentEffect = new class'X2Effect_Persistent';
	PersistentEffect.BuildPersistentEffect(1, true, false);
	PersistentEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.LocLongDescription, Template.IconImage, true,, Template.AbilitySourceName);
	PersistentEffect.DuplicateResponse = eDupe_Ignore;
	Template.AddShooterEffect(PersistentEffect);

	DisorientedEffect = class'X2StatusEffects'.static.CreateDisorientedStatusEffect(, , false);
	ExplodingCondition = new class'X2Condition_AbilityProperty';
	ExplodingCondition.OwnerHasSoldierAbilities.AddItem('RM_ExplodingBiotics');
	DisorientedEffect.TargetConditions.AddItem(ExplodingCondition);
	Template.AddMultiTargetEffect(DisorientedEffect);


	Template.AbilityMultiTargetConditions.AddItem(default.LivingHostileUnitOnlyProperty);

// 	Template.CustomSelfFireAnim = 'FF_FireMedkitSelf';
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;		
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;  
	Template.bSkipFireAction = true;
	Template.bShowActivation = true;

 	return Template;
}
 

static function X2AbilityTemplate BioticWind()
{
	local X2AbilityTemplate             Template;
	local X2Effect_BioticWind              SustainEffect;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticWind');

	Template.IconImage = "img:///XPerkIconPack.UIPerk_stasis_defense";
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;
	Template.bIsPassive = true;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	SustainEffect = new class'X2Effect_BioticWind';
	SustainEffect.BuildPersistentEffect(1, true, true);
	SustainEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, true,, Template.AbilitySourceName);
	Template.AddTargetEffect(SustainEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	// Note: no visualization on purpose!

	Template.AdditionalAbilities.AddItem('RM_BioticWindTriggered');

	return Template;
}

static function X2DataTemplate BioticWindTriggered()
{
	local X2AbilityTemplate                 Template;
	local X2Effect_Stasis                   StasisEffect;
	local X2AbilityTrigger_EventListener    EventTrigger;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticWindTriggered');

	Template.Hostility = eHostility_Neutral;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_stasis_defense";
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_NeverShow;
	Template.AbilitySourceName = 'eAbilitySource_Psionic';

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;

	StasisEffect = new class'X2Effect_Stasis';
	StasisEffect.BuildPersistentEffect(1, false, false, false, eGameRule_PlayerTurnBegin);
	StasisEffect.bUseSourcePlayerState = true;
	StasisEffect.bRemoveWhenTargetDies = true;          //  probably shouldn't be possible for them to die while in stasis, but just in case
	StasisEffect.SetDisplayInfo(ePerkBuff_Penalty, Template.LocFriendlyName, Template.GetMyHelpText(), Template.IconImage);
	StasisEffect.StunStartAnim = 'HL_PsiSustainStart';
	StasisEffect.bSkipFlyover = true;
	Template.AddTargetEffect(StasisEffect);

	EventTrigger = new class'X2AbilityTrigger_EventListener';
	EventTrigger.ListenerData.Deferral = ELD_OnStateSubmitted;
	EventTrigger.ListenerData.EventID = class'X2Effect_BioticWind'.default.BioticWindEvent;
	EventTrigger.ListenerData.Filter = eFilter_Unit;
	EventTrigger.ListenerData.EventFn = class'XComGameState_Ability'.static.AbilityTriggerEventListener_Self_VisualizeInGameState;
	Template.AbilityTriggers.AddItem(EventTrigger);

	Template.PostActivationEvents.AddItem(class'X2Effect_BioticWind'.default.BioticWindTriggeredEvent);
		
	Template.bSkipFireAction = true;
	Template.FrameAbilityCameraType = eCameraFraming_Never;
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;

	return Template;
}
static function X2AbilityTemplate WarpShot()
{
	local X2AbilityTemplate                 Template;	
	local X2AbilityCost_Ammo                AmmoCost;
	local X2AbilityCost_ActionPoints        ActionPointCost;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect, BonusDamageEffect;
	local array<name>                       SkipExclusions;
	local X2AbilityToHitCalc_StandardAim    StandardAim;
	local X2AbilityCooldown_Bonus                 Cooldown;
	local X2Condition_AbilityProperty   DevastateCondition;   

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_WarpShot');

	// Icon Properties
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_shot";
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_COLONEL_PRIORITY;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.DisplayTargetHitChance = true;
	Template.AbilityConfirmSound = "TacticalUI_ActivateAbility";
	Template.Hostility = eHostility_Offensive;

	// Activated by a button press; additionally, tells the AI this is an activatable
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	// *** VALIDITY CHECKS *** //
	//  Normal effect restrictions (except disoriented)
	SkipExclusions.AddItem(class'X2AbilityTemplateManager'.default.DisorientedName);
	Template.AddShooterEffectExclusions(SkipExclusions);

	// Targeting Details
	// Can only shoot visible enemies
	Template.AbilityTargetConditions.AddItem(default.GameplayVisibilityCondition);
	// Can't target dead; Can't target friendlies
	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);
	// Can't shoot while dead
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	// Only at single targets that are in range.
	Template.AbilityTargetStyle = default.SimpleSingleTarget;

	// Action Point
	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	ActionPointCost.bConsumeAllPoints = true;
	ActionPointCost.DoNotConsumeAllEffects.AddItem('RM_BioticOverdrive');
	Template.AbilityCosts.AddItem(ActionPointCost);	

	// Ammo
	AmmoCost = new class'X2AbilityCost_Ammo';	
	AmmoCost.iAmmo = default.WarpShot_Ammo;
	Template.AbilityCosts.AddItem(AmmoCost);
	Template.bAllowAmmoEffects = true;

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.WarpShot_Cooldown;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	// Weapon Upgrade Compatibility
	Template.bAllowFreeFireWeaponUpgrade = true;                                            // Flag that permits action to become 'free action' via 'Hair Trigger' or similar upgrade / effects

	WeaponDamageEffect = class'X2Ability_GrenadierAbilitySet'.static.ShredderDamageEffect();
	//WeaponDamageEffect.bIgnoreBaseDamage = true;
	WeaponDamageEffect.EffectDamageValue.Rupture = default.WarpShot_Rupture;
	//WeaponDamageEffect.EffectDamageValue.Damage = default.WarpShot_Damage;
	//WeaponDamageEffect.DamageTag = 'WarpShot';
	Template.AddTargetEffect(WeaponDamageEffect);
	Template.bAllowBonusWeaponEffects = true;
	Template.bAllowAmmoEffects = true;
	
	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddTargetEffect(BonusDamageEffect);	
		
	Template.AddTargetEffect(class'X2Ability_GrenadierAbilitySet'.static.HoloTargetEffect());
	Template.AssociatedPassives.AddItem('HoloTargeting');

	Template.AbilityToHitCalc = default.DeadEye;

		
	// Targeting Method
	Template.TargetingMethod = class'X2TargetingMethod_OverTheShoulder';
	Template.bUsesFiringCamera = true;
	Template.CinescriptCameraType = "StandardGunFiring";

	// Voice events
	Template.ActivationSpeech = 'BulletShred';

	// MAKE IT LIVE!
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;	
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;

	return Template;	
}


static function X2AbilityTemplate ReactiveBarrier()
{
	local X2AbilityTemplate						Template;
	local X2AbilityTargetStyle                  TargetStyle;
	local X2AbilityTrigger						Trigger;
	local X2Effect_ReactiveBarrier                 PaddingEffect;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_ReactiveBarrier');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_crit2";

	Template.AbilityToHitCalc = default.DeadEye;

	TargetStyle = new class'X2AbilityTarget_Self';
	Template.AbilityTargetStyle = TargetStyle;

	Trigger = new class'X2AbilityTrigger_UnitPostBeginPlay';
	Template.AbilityTriggers.AddItem(Trigger);

	PaddingEffect = new class'X2Effect_ReactiveBarrier';
	PaddingEffect.DamageReduction = default.ReactiveBarrier_DMG_ADJUST;
	PaddingEffect.BuildPersistentEffect(1, true, false);
	PaddingEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyHelpText(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(PaddingEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!


	return Template;
}


static function X2AbilityTemplate BioticTraversal()
{
	local X2AbilityTemplate Template;	
	local X2Effect_PersistentTraversalChange	JumpServosEffect;
	local X2Effect_AdditionalAnimSets			IcarusAnimSet;
	local X2Effect_PersistentStatChange StatChange;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticTraversal');

	Template.Hostility = eHostility_Neutral;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_NeverShow;
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	//Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_item_wraith";
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_plus";

	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityShooterConditions.AddItem( default.LivingShooterProperty );
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	Template.AbilityToHitCalc = default.DeadEye;


	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.bSkipFireAction = true;
	Template.FrameAbilityCameraType = eCameraFraming_Never;
	Template.bSkipPerkActivationActions = true; // we'll trigger related perks as part of the movement action

	// Give the unit the JumpUp traversal type
	JumpServosEffect = new class'X2Effect_PersistentTraversalChange';
	JumpServosEffect.BuildPersistentEffect( 1, true, true, false, eGameRule_PlayerTurnBegin );
	JumpServosEffect.SetDisplayInfo( ePerkBuff_Bonus, Template.LocFriendlyName, Template.GetMyHelpText( ), Template.IconImage, true );
	JumpServosEffect.AddTraversalChange( eTraversal_JumpUp, true );
	JumpServosEffect.EffectName = 'BioticJump';
	JumpServosEffect.DuplicateResponse = eDupe_Refresh;

	Template.AddTargetEffect( JumpServosEffect );

	StatChange = new class'X2Effect_PersistentStatChange';
	StatChange.EffectName = 'BioticDefence';
	StatChange.DuplicateResponse = eDupe_Ignore;
	StatChange.BuildPersistentEffect( 1, true, true, false, eGameRule_PlayerTurnBegin );
	StatChange.AddPersistentStatChange(eStat_Defense, default.BIOTIC_DEFENCE);

	Template.AddTargetEffect(StatChange);
	// Because the DLC's animations do not exist in an uncooked state, we cannot add them to the weapon's archetype in the editor
	// Instead, this function will add the anims to the soldier for 1 turn, when the ability is activated.
	IcarusAnimSet = new class'X2Effect_AdditionalAnimSets';
	IcarusAnimSet.BuildPersistentEffect( 1, true, true, false, eGameRule_PlayerTurnBegin );
	//IcarusAnimSet.SetDisplayInfo( ePerkBuff_Bonus, Template.LocFriendlyName, Template.GetMyHelpText( ), Template.IconImage, true );
	IcarusAnimSet.AddAnimSetWithPath( "DLC_60_Soldier_IcarusSuit_ANIM.Anims.AS_IcarusSuit" );
	
	Template.AddTargetEffect( IcarusAnimSet );


	return Template;
}

//normal biotic barrier

static function X2AbilityTemplate BioticBarrier()
{
	local X2AbilityTemplate Template;
	local X2Effect_EnergyShield ShieldedEffect;
	local array<name> SkipExclusions;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticBarrier');
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_circle"; // TODO: This needs to be changed; 

	//Template.bDontDisplayInAbilitySummary = true;

	Template.AdditionalAbilities.AddItem('RM_BioticRegen');
	Template.AdditionalAbilities.AddItem('RM_BioticRebuild');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;

	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	//build shield effect
	ShieldedEffect = new class'X2Effect_EnergyShield';
	ShieldedEffect.BuildPersistentEffect(1, true, true); //, , eGameRule_PlayerTurnEnd
	ShieldedEffect.SetDisplayInfo(ePerkBuff_Bonus, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	ShieldedEffect.AddPersistentStatChange(eStat_ShieldHP, default.BarrierPoints);
	ShieldedEffect.EffectName = 'RMBioticBarrierEffect';
	Template.AddTargetEffect(ShieldedEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;

	return Template;
}


static function X2AbilityTemplate BioticRegen()
{
	local X2AbilityTemplate Template;
	local X2Effect_BioticRegen RegenerationEffect;
	//local array<name> SkipExclusions;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticRegen');
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_circle"; // TODO: This needs to be changed; 

	Template.bDontDisplayInAbilitySummary = true;

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;

	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	// Build the regeneration effect
	RegenerationEffect = new class'X2Effect_BioticRegen';
	RegenerationEffect.BuildPersistentEffect(1,  true, true, false, eGameRule_PlayerTurnBegin);
//	RegenerationEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	RegenerationEffect.HealAmount = default.RegenPoints;
	RegenerationEffect.HealLimit = default.BarrierPoints;
	Template.AddTargetEffect(RegenerationEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;

	return Template;
}


static function X2DataTemplate BioticRebuild()
{
	local X2AbilityTemplate Template;
	local X2Condition_UnitProperty UnitPropertyCondition;
	local X2Effect_PersistentStatChange ShieldedEffect;
    local X2AbilityTrigger_EventListener    EventListener;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticRebuild');
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_circle";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;

	//Can't use while dead
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);

    // Placeholder trigger
    Template.AbilityTriggers.Length = 0;

    EventListener = new class'X2AbilityTrigger_EventListener';
    EventListener.ListenerData.Deferral = ELD_OnStateSubmitted;
    EventListener.ListenerData.EventID = 'BioticRegainBarrier';
    EventListener.ListenerData.EventFn = class'XComGameState_Ability'.static.AbilityTriggerEventListener_Self;
    EventListener.ListenerData.Filter = eFilter_Unit;
    Template.AbilityTriggers.AddItem(EventListener);

	// Friendlies in the radius receives a shield receives a shield
	ShieldedEffect = CreateShieldedEffect(Template.LocFriendlyName, Template.GetMyLongDescription());

	Template.AddShooterEffect(ShieldedEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//Template.BuildVisualizationFn = Shielded_BuildVisualization;
	//Template.CinescriptCameraType = "AdvShieldBearer_EnergyShieldArmor";
	
	return Template;
}

static function X2Effect_PersistentStatChange CreateShieldedEffect(string FriendlyName, string LongDescription)
{
	local X2Effect_EnergyShield ShieldedEffect;

	ShieldedEffect = new class'X2Effect_EnergyShield';
	ShieldedEffect.BuildPersistentEffect(1, true, true); //, , eGameRule_PlayerTurnEnd
	ShieldedEffect.SetDisplayInfo(ePerkBuff_Bonus, FriendlyName, LongDescription, "img:///UILibrary_PerkIcons.UIPerk_absorption_fields", true);
	ShieldedEffect.AddPersistentStatChange(eStat_ShieldHP, default.RegenPoints);
	//ShieldedEffect.EffectRemovedVisualizationFn = OnShieldRemoved_BuildVisualization;

	return ShieldedEffect;
}

//safeguard biotic barrier



static function X2AbilityTemplate Safeguard()
{
	local X2AbilityTemplate Template;
	local X2Effect_EnergyShield ShieldedEffect;
	local array<name> SkipExclusions;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Safeguard');
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_cycle"; // TODO: This needs to be changed; 

	//Template.bDontDisplayInAbilitySummary = true;

	Template.AdditionalAbilities.AddItem('RM_SafeguardRegen');
	Template.AdditionalAbilities.AddItem('RM_BioticRebuild');
	Template.OverrideAbilities.AddItem('RM_BioticBarrier');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;

	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	//build shield effect
	ShieldedEffect = new class'X2Effect_EnergyShield';
	ShieldedEffect.BuildPersistentEffect(1, true, true); //, , eGameRule_PlayerTurnEnd
	ShieldedEffect.SetDisplayInfo(ePerkBuff_Bonus, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	ShieldedEffect.AddPersistentStatChange(eStat_ShieldHP, default.SafeguardPoints);
	ShieldedEffect.EffectName = 'SafeguardBarrierEffect';
	Template.AddTargetEffect(ShieldedEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;

	return Template;
}


static function X2AbilityTemplate SafeguardRegen()
{
	local X2AbilityTemplate Template;
	local X2Effect_BioticRegen RegenerationEffect;
	//local array<name> SkipExclusions;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_SafeguardRegen');
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_cycle"; // TODO: This needs to be changed; 

	Template.bDontDisplayInAbilitySummary = true;

	Template.OverrideAbilities.AddItem('RM_BioticRegen');

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;

	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	// Build the regeneration effect
	RegenerationEffect = new class'X2Effect_BioticRegen';
	RegenerationEffect.BuildPersistentEffect(1,  true, true, false, eGameRule_PlayerTurnBegin);
//	RegenerationEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	RegenerationEffect.HealAmount = default.RegenPoints;
	RegenerationEffect.HealLimit = default.SafeguardPoints;
	Template.AddTargetEffect(RegenerationEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;

	return Template;
}


static function X2AbilityTemplate BioticTeleport()
{
	local X2AbilityTemplate Template;
	local X2AbilityCost_ActionPoints ActionPointCost;
	local X2AbilityCooldown_Bonus Cooldown;
	local X2AbilityTarget_Cursor CursorTarget;
	local X2AbilityMultiTarget_Radius RadiusMultiTarget;
	local X2AbilityTrigger_PlayerInput InputTrigger;
	local X2Effect_AdditionalAnimSets						AnimSets;
	

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_BioticTeleport');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_AlwaysShow;
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_codex_teleport";

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	Template.AbilityCosts.AddItem(ActionPointCost);

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.TeleportCooldown;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	Template.TargetingMethod = class'X2TargetingMethod_Teleport';

	InputTrigger = new class'X2AbilityTrigger_PlayerInput';
	Template.AbilityTriggers.AddItem(InputTrigger);

	Template.AbilityToHitCalc = default.DeadEye;

	CursorTarget = new class'X2AbilityTarget_Cursor';
	CursorTarget.bRestrictToSquadsightRange = true;
	CursorTarget.FixedAbilityRange = default.Teleport_Range;     // yes there is.
	Template.AbilityTargetStyle = CursorTarget;

	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("BioticAnimations.Anims.AS_VoidStrike");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	RadiusMultiTarget = new class'X2AbilityMultiTarget_Radius';
	RadiusMultiTarget.fTargetRadius = 0.25; // small amount so it just grabs one tile
	Template.AbilityMultiTargetStyle = RadiusMultiTarget;

	// Shooter Conditions
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	//// Damage Effect
	Template.AbilityMultiTargetConditions.AddItem(default.LivingTargetUnitOnlyProperty);
	//TeleportDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	//TeleportDamageEffect.EffectDamageValue = class'X2Item_DefaultWeapons'.default.CYBERUS_TELEPORT_BASEDAMAGE;
	//TeleportDamageEffect.EnvironmentalDamageAmount = default.TELEPORT_ENVIRONMENT_DAMAGE_AMOUNT;
	//TeleportDamageEffect.EffectDamageValue.DamageType = 'Melee';
	//Template.AddMultiTargetEffect(TeleportDamageEffect);

	Template.ModifyNewContextFn = Teleport_ModifyActivatedAbilityContext;
	Template.BuildNewGameStateFn = Teleport_BuildGameState;
	Template.BuildVisualizationFn = Teleport_BuildVisualization;
	Template.CinescriptCameraType = "Cyberus_Teleport";
	Template.bShowActivation = true;
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;

	return Template;
}


static simulated function Teleport_ModifyActivatedAbilityContext(XComGameStateContext Context)
{
	local XComGameState_Unit UnitState;
	local XComGameStateContext_Ability AbilityContext;
	local XComGameStateHistory History;
	local PathPoint NextPoint, EmptyPoint;
	local PathingInputData InputData;
	local XComWorldData World;
	local vector NewLocation;
	local TTile NewTileLocation;

	History = `XCOMHISTORY;
	World = `XWORLD;

	AbilityContext = XComGameStateContext_Ability(Context);
	`assert(AbilityContext.InputContext.TargetLocations.Length > 0);
	
	UnitState = XComGameState_Unit(History.GetGameStateForObjectID(AbilityContext.InputContext.SourceObject.ObjectID));

	// Build the MovementData for the path
	// First posiiton is the current location
	InputData.MovementTiles.AddItem(UnitState.TileLocation);

	NextPoint.Position = World.GetPositionFromTileCoordinates(UnitState.TileLocation);
	NextPoint.Traversal = eTraversal_Teleport;
	NextPoint.PathTileIndex = 0;
	InputData.MovementData.AddItem(NextPoint);

	// Second posiiton is the cursor position
	`assert(AbilityContext.InputContext.TargetLocations.Length == 1);

	NewLocation = AbilityContext.InputContext.TargetLocations[0];
	NewTileLocation = World.GetTileCoordinatesFromPosition(NewLocation);
	NewLocation = World.GetPositionFromTileCoordinates(NewTileLocation);

	NextPoint = EmptyPoint;
	NextPoint.Position = NewLocation;
	NextPoint.Traversal = eTraversal_Landing;
	NextPoint.PathTileIndex = 1;
	InputData.MovementData.AddItem(NextPoint);
	InputData.MovementTiles.AddItem(NewTileLocation);

    //Now add the path to the input context
	InputData.MovingUnitRef = UnitState.GetReference();
	AbilityContext.InputContext.MovementPaths.AddItem(InputData);
}

static simulated function XComGameState Teleport_BuildGameState(XComGameStateContext Context)
{
	local XComGameState NewGameState;
	local XComGameState_Unit UnitState;
	local XComGameStateContext_Ability AbilityContext;
	local vector NewLocation;
	local TTile NewTileLocation;
	local XComWorldData World;
	local X2EventManager EventManager;
	local int LastElementIndex;

	World = `XWORLD;
	EventManager = `XEVENTMGR;

	//Build the new game state frame
	NewGameState = TypicalAbility_BuildGameState(Context);

	AbilityContext = XComGameStateContext_Ability(NewGameState.GetContext());	
	UnitState = XComGameState_Unit(NewGameState.CreateStateObject(class'XComGameState_Unit', AbilityContext.InputContext.SourceObject.ObjectID));

	LastElementIndex = AbilityContext.InputContext.MovementPaths[0].MovementData.Length - 1;

	// Set the unit's new location
	// The last position in MovementData will be the end location
	`assert(LastElementIndex > 0);
	NewLocation = AbilityContext.InputContext.MovementPaths[0].MovementData[LastElementIndex].Position;
	NewTileLocation = World.GetTileCoordinatesFromPosition(NewLocation);
	UnitState.SetVisibilityLocation(NewTileLocation);

	NewGameState.AddStateObject(UnitState);

	AbilityContext.ResultContext.bPathCausesDestruction = MoveAbility_StepCausesDestruction(UnitState, AbilityContext.InputContext, 0, AbilityContext.InputContext.MovementPaths[0].MovementTiles.Length - 1);
	MoveAbility_AddTileStateObjects(NewGameState, UnitState, AbilityContext.InputContext, 0, AbilityContext.InputContext.MovementPaths[0].MovementTiles.Length - 1);

	EventManager.TriggerEvent('ObjectMoved', UnitState, UnitState, NewGameState);
	EventManager.TriggerEvent('UnitMoveFinished', UnitState, UnitState, NewGameState);

	//Return the game state we have created
	return NewGameState;
}

simulated function Teleport_BuildVisualization(XComGameState VisualizeGameState)
{
	local XComGameStateHistory History;
	local XComGameStateContext_Ability  AbilityContext;
	local StateObjectReference InteractingUnitRef;
	local X2AbilityTemplate AbilityTemplate;
	local VisualizationActionMetadata EmptyTrack, BuildTrack;
	local X2Action_PlaySoundAndFlyOver SoundAndFlyover;
	local int i, j;
	local XComGameState_WorldEffectTileData WorldDataUpdate;
	local X2Action_MoveTurn MoveTurnAction;
	local X2VisualizerInterface TargetVisualizerInterface;
	local X2Action_PlayEffect EffectAction;
	local XComWorldData World;
	local vector TargetLocation;
	local TTile TargetTile;

	History = `XCOMHISTORY;
	World = `XWORLD;
	AbilityContext = XComGameStateContext_Ability(VisualizeGameState.GetContext());
	InteractingUnitRef = AbilityContext.InputContext.SourceObject;

	AbilityTemplate = class'XComGameState_Ability'.static.GetMyTemplateManager().FindAbilityTemplate(AbilityContext.InputContext.AbilityTemplateName);

	//****************************************************************************************
	//Configure the visualization track for the source
	//****************************************************************************************
	BuildTrack = EmptyTrack;
	BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
	BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
	BuildTrack.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);

	SoundAndFlyOver = X2Action_PlaySoundAndFlyOver(class'X2Action_PlaySoundAndFlyover'.static.AddToVisualizationTree(BuildTrack, AbilityContext));
	SoundAndFlyOver.SetSoundAndFlyOverParameters(None, AbilityTemplate.LocFlyOverText, '', eColor_Good);

	// Turn to face the target action. The target location is the center of the ability's radius, stored in the 0 index of the TargetLocations
	MoveTurnAction = X2Action_MoveTurn(class'X2Action_MoveTurn'.static.AddToVisualizationTree(BuildTrack, AbilityContext));
	MoveTurnAction.m_vFacePoint = AbilityContext.InputContext.TargetLocations[0];

	// move action
	class'X2VisualizerHelpers'.static.ParsePath(AbilityContext, BuildTrack);

	// Display the Warning FX (convert to tile and back to vector because stage 2 is at the GetPositionFromTileCoordinates coord
	//EffectAction = X2Action_PlayEffect(class'X2Action_PlayEffect'.static.AddToVisualizationTrack(BuildTrack, AbilityContext));
	//EffectAction.EffectName = "FX_Psi_Null_Lance.P_Psi_Null_Lance_Projectile";
	//TargetLocation = AbilityContext.InputContext.TargetLocations[0];
	//TargetTile = World.GetTileCoordinatesFromPosition(TargetLocation);
//
	//EffectAction.EffectLocation = World.GetPositionFromTileCoordinates(TargetTile);


//	OutVisualizationTracks.AddItem(BuildTrack);
	
	//****************************************************************************************

	foreach VisualizeGameState.IterateByClassType(class'XComGameState_WorldEffectTileData', WorldDataUpdate)
	{
		BuildTrack = EmptyTrack;
		BuildTrack.VisualizeActor = none;
		BuildTrack.StateObject_NewState = WorldDataUpdate;
		BuildTrack.StateObject_OldState = WorldDataUpdate;

		for (i = 0; i < AbilityTemplate.AbilityTargetEffects.Length; ++i)
		{
			AbilityTemplate.AbilityTargetEffects[i].AddX2ActionsForVisualization(VisualizeGameState, BuildTrack, AbilityContext.FindTargetEffectApplyResult(AbilityTemplate.AbilityTargetEffects[i]));
		}

		//OutVisualizationTracks.AddItem(BuildTrack);
	}

	//****************************************************************************************
	//Configure the visualization track for the targets
	//****************************************************************************************
	for( i = 0; i < AbilityContext.InputContext.MultiTargets.Length; ++i )
	{
		InteractingUnitRef = AbilityContext.InputContext.MultiTargets[i];
		BuildTrack = EmptyTrack;
		BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
		BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
		BuildTrack.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);

		class'X2Action_WaitForAbilityEffect'.static.AddToVisualizationTree(BuildTrack, AbilityContext);
		for( j = 0; j < AbilityContext.ResultContext.MultiTargetEffectResults[i].Effects.Length; ++j )
		{
			AbilityContext.ResultContext.MultiTargetEffectResults[i].Effects[j].AddX2ActionsForVisualization(VisualizeGameState, BuildTrack, AbilityContext.ResultContext.MultiTargetEffectResults[i].ApplyResults[j]);
		}

		TargetVisualizerInterface = X2VisualizerInterface(BuildTrack.VisualizeActor);
		if( TargetVisualizerInterface != none )
		{
			//Allow the visualizer to do any custom processing based on the new game state. For example, units will create a death action when they reach 0 HP.
			TargetVisualizerInterface.BuildAbilityEffectsVisualization(VisualizeGameState, BuildTrack);
		}

		//if (BuildTrack.TrackActions.Length > 0)
		//{
			//OutVisualizationTracks.AddItem(BuildTrack);
		//}
	}
}

